# -*- coding: utf-8 -*-

import json,urllib
from lamlib import bookmarks
from lamlib import directory
from lamlib import client
from lamlib import cache

class indexer:
    def __init__(main_root):
        main_root.list = []
        main_root.base_link = 'http://www.nrj.fr'
        main_root.player_image = 'http://players.nrjaudio.fm/live-metadata/player/img/player-files/nrj/logos/640x640/%s'
        main_root.player_api = 'http://players.nrjaudio.fm/wr_api/live?id_radio=1&act=get_setup&fmt=json&cp=UTF8'

    def root(main_root):
        main_root.list = [
        {
        #'title': 32001, #Radios
		'title': '[COLOR lime][B]NRJ Radios[/B][/COLOR]', #Radios
        'action': 'radios'
        },

        {
        #'title': 32002, #Favorites
		'title': '[COLOR lime][B]Favorites[/B][/COLOR]', #Favorites
        'action': 'bookmarks'
        }
        ]
		
        directory.add(main_root.list, content='files')
        return main_root.list

    def bookmarks(main_root):
        main_root.list = bookmarks.get()
        if main_root.list == None: return
        for i in main_root.list:
            bookmark = dict((k,v) for k, v in i.iteritems() if not k == 'next')
            bookmark['delbookmark'] = i['url']
			#i.update({'cm': [{'title': 32502, 'query': {'action': 'deleteBookmark', 'url': json.dumps(bookmark)}}]})
            i.update({'cm': [{'title': '[COLOR lime][B]Remove From Favorites[/B][/COLOR]', 'query': {'action': 'deleteBookmark', 'url': json.dumps(bookmark)}}]})
        main_root.list = sorted(main_root.list, key=lambda k: k['title'].lower())
        directory.add(main_root.list, infotype='Music')
        return main_root.list

    def radios(main_root):
        main_root.list = cache.get(main_root.item_list, 0, main_root.player_api)
        if main_root.list == None: return
        for i in main_root.list: i.update({'action': 'play', 'isFolder': 'False'})
        for i in main_root.list:
            bookmark = dict((k,v) for k, v in i.iteritems() if not k == 'next')
            bookmark['bookmark'] = i['url'] # Add to Favorites
            i.update({'cm': [{'title': '[COLOR lime][B]Add to Favorites[/B][/COLOR]', 'query': {'action': 'addBookmark', 'url': json.dumps(bookmark)}}]})
			#i.update({'cm': [{'title': 32501, 'query': {'action': 'addBookmark', 'url': json.dumps(bookmark)}}]})
        directory.add(main_root.list, infotype='Music')
        return main_root.list

#< PLAYER >#
    def play(main_root, url):
        resolved = main_root.resolve(url)
        if resolved == None: return
        title, url, image = resolved
        directory.resolve(url, {'title': title}, image)

    def item_list(main_root, url):
        try:
            result = client.request(url, mobile=True)
            result = json.loads(result)
            items = result['webradios']
        except:
        	return

        for item in items:
            try:
                title = item['name'].strip()
                title = title.encode('utf-8')
                url = item['web_url'].strip()
                url = [i for i in url.split('/') if not i == ''][-1]
                url = url.encode('utf-8')
                uid = []
                uid.append(item['url_triton_64k_aac'])
                uid.append(item['url_64k_aac'])
                uid.append(item['url_triton_128k_mp3'])
                uid.append(item['url_128k_mp3'])
                uid.append(item['url_hls'])
                uid.append(item['url_hd_aac'])
                uid = [i for i in uid if '//' in i and not '.flv' in i][0]
                uid = uid.encode('utf-8')
                image = item['logo'].strip()
                image = main_root.player_image % image
                image = image.encode('utf-8')
                main_root.list.append({'title': ("[COLOR lime][B]%s [/B][/COLOR]") % title, 'url': url, 'uid': uid, 'image': image})
				#main_root.list.append({'title': title, 'url': url, 'uid': uid, 'image': image})
            except:
                pass
        return main_root.list

    def resolve(main_root, url):
        try:
            headers = {'User-Agent': 'NSPlayer/12.00.14393.0693 WMFSDK/12.00.14393.0693'}
            item = cache.get(main_root.item_list, 24, main_root.player_api)
            item = [i for i in item if url == i['url']][0]
            title, url, image = item['title'], item['uid'], item['image']
            url = client.request(url, headers=headers, output='geturl')
            url += '|%s' % urllib.urlencode(headers)
            return (title, url, image)
        except:
        	pass
